#!/bin/bash

# If this script (called post_install_script.sh) is present in a folder
# called post.install in the linux.<product> folder of a given patch,
# applypatch will run it and pass it the $InstallPath for this patch.
#
# The purpose of this script is to run some custom operation after
# a patch is applied. Modify this script as needed.
PROG=$(basename $0)
CWD=$(cd $(dirname $0) && pwd)

PORTAL_INIT_SCRIPT="framework/etc/agsportal.sh"
SERVER_INIT_SCRIPT="framework/etc/scripts/agsserver.sh"
DATASTORE_INIT_SCRIPT="framework/etc/scripts/arcgisdatastore.sh"
NOTEBOOK_INIT_SCRIPT="framework/etc/scripts/agsnotebook.sh"
MISSION_INIT_SCRIPT="framework/etc/scripts/agsmissionserver.sh"

usage()
{
  cat <<EOF

  ${PROG} - Run a post-applypatch operation

  USAGE: % ./${PROG} [product_install_dir]

EOF
  exit 0
}

fail()
{
  echo ""
  echo "ERROR: $1"
  echo ""
  exit 1
}

run_step()
{
  installpath="$1"

  product="$( basename ${installpath} )"

  if [ -f ${installpath}/${SERVER_INIT_SCRIPT} ]; then
     INSTALL_SCRIPT=${installpath}/${SERVER_INIT_SCRIPT}
  elif [ -f ${installpath}/${PORTAL_INIT_SCRIPT} ]; then
     INSTALL_SCRIPT=${installpath}/${PORTAL_INIT_SCRIPT}
  elif [ -f ${installpath}/${DATASTORE_INIT_SCRIPT} ]; then
     INSTALL_SCRIPT=${installpath}/${DATASTORE_INIT_SCRIPT}
  elif [ -f ${installpath}/${NOTEBOOK_INIT_SCRIPT} ]; then
     INSTALL_SCRIPT=${installpath}/${NOTEBOOK_INIT_SCRIPT}
  elif [ -f ${installpath}/${MISSION_INIT_SCRIPT} ]; then
     INSTALL_SCRIPT=${installpath}/${MISSION_INIT_SCRIPT}     
  else
    fail "Could not find product init script."
  fi

  echo "Running post install script for $product..."

  if [ ! -f "$INSTALL_SCRIPT" ]; then
    echo "Could not find install script: $INSTALL_SCRIPT. Skipping post-install step."
    return
  fi

  # RUN CUSTOM POST-INSTALL COMMANDS HERE
  CMD="${INSTALL_SCRIPT} updateFiles log4j"
  echo "Running command: $CMD"

  # Run it
  eval $CMD
  [ $? -ne 0 ] && fail "Post-install step failed"

  echo "Waiting for completion..."
  sleep 15
  echo ""
  echo "Post-install step SUCCEEDED!"
}

Main()
{
  [ $# -ne 1 ] && usage

  run_step "$1"
}

Main "$@"
